@extends('includes/layout')
@section('main-page-content')
    <div class="container-xxl flex-grow-1 container-p-y">
        <div class="card mb-1">
            <div class="card-body mb-2">
                <div class="border-bottom pb-2 ps-1">
                    <div class="h4 pb-0 mb-0 ">Add Salary</div>
                    <small>Dashboard-Salary</small>
                </div>
                <form id="siteForm" method="POST" action="{{ route('salary.store') }}">
                    @csrf
                    <div class="row mt-3">

                        <div class="col-md-4 form-group mb-3">
                            <label for="thumbnail" class="text-dark">Employee<span class="text-danger">*</span></label>
                            <select class="employe_id form-select mt-1" id="employe_id" name="employee_id">
                                <option value="">--Select--</option>
                                @foreach ($get_employes as $get_employe)
                                    @if ($get_employe->EmpPersonalDetails)
                                        <option value="{{ $get_employe->id }}">
                                            {{ $get_employe->EmpPersonalDetails->first_name }}
                                            {{ $get_employe->EmpPersonalDetails->middle_name }}
                                            {{ $get_employe->EmpPersonalDetails->last_name }}
                                        </option>
                                    @endif
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-4 form-group mb-3">
                            <label for="from" class="text-dark">From<span class="text-danger">*</span></label>
                            <input type="month" name="from" id="from" class="form-control mt-1" required>
                        </div>
                        <div class="col-md-4 form-group mb-3">
                            <label for="to" class="text-dark">To<span class="text-danger">*</span></label>
                            <input type="month" name="to" id="to" class="form-control mt-1" required>
                        </div>

                        <div class="col-md-4 form-group mb-3">
                            <label for="basic_salary" class="text-dark">Salary<span class="text-danger">*</span></label>
                            <input type="number" name="basic_salary" id="basic_salary" class="form-control mt-1"
                                placeholder="Enter Salary Amount" required min="0" step="0.01">
                        </div>

                            <input type="hidden" name="working_hours" id="working_hours" value="0" class="form-control mt-1"
                                placeholder="Enter Fine Amount" required min="0" step="0.01">

                    </div>
                    <div class="mt-3 d-flex justify-content-end">
                        <div class="col-md-12 text-end">
                            <button type="submit" class="btn btn-primary">Save and Submit</button>
                        </div>
                    </div>
                </form>

            </div>
        </div>
    </div>
@endsection
