@extends('includes/layout')
@section('main-page-content')
    <div class="container-xxl flex-grow-1 container-p-y">
        <div class="card mb-1">
            <div class="card-body mb-2">
                <div class="border-bottom pb-2 ps-1">
                    <div class="h4 pb-0 mb-0 ">Edit Salary</div>
                    <small>Dashboard-Salary </small>
                </div>
                <form method="POST" action="{{ route('salary.update', $salary->id) }}">
                @if ($errors->any())
        <div class="alert alert-danger">
            <strong>Whoops!</strong> There were some problems with your input.<br><br>
            <ul>
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif
                    @csrf
                    @method('PUT')
                    <div class="row mt-3">

                        <div class="col-md-4 form-group mb-3">
                            <label for="thumbnail" class="text-dark">Employee<span class="text-danger">*</span></label>
                            <select name="employee_id" id="employee_id" class="form-control" required>
                                @foreach ($get_employees as $employee)
                                    <option value="{{ $employee->id }}"
                                        {{ $employee->id == $salary->employee_id ? 'selected' : '' }}>
                                        {{ $employee->EmpPersonalDetails->first_name }}
                                        {{ $employee->EmpPersonalDetails->middle_name }}
                                        {{ $employee->EmpPersonalDetails->last_name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-4 form-group mb-3">
                            <label for="from" class="text-dark">From<span class="text-danger">*</span></label>
                            <input type="month" name="from" value="{{ $salary->from }}" id="from"
                                class="form-control mt-1" required>
                        </div>
                        <div class="col-md-4 form-group mb-3">
                            <label for="to" class="text-dark">To<span class="text-danger">*</span></label>
                            <input type="month" name="to" id="to" value="{{ $salary->to }}"
                                class="form-control mt-1" required>
                        </div>

                        <div class="col-md-4 form-group mb-3">
                            <label for="basic_salary" class="text-dark">Salary<span class="text-danger">*</span></label>
                            <input type="number" name="basic_salary" value="{{ $salary->basic_salary }}" id="basic_salary"
                                class="form-control mt-1" placeholder="Enter salary Amount" required min="0"
                                step="0.01">
                        </div>
                        {{-- <div class="col-md-4 form-group mb-3">
                            <label for="working_hours" class="text-dark">Working Hours<span
                                    class="text-danger">*</span></label> --}}
                            <input type="hidden" name="working_hours" value="{{ $salary->working_hours }}" value="0" id="working_hours"
                                class="form-control mt-1" placeholder="Enter salary Amount" required min="0"
                                step="0.01">
                        {{-- </div> --}}

                    </div>
                    <div class="mt-3 d-flex justify-content-end">
                        <div class="col-md-12 text-end mt-3">
                            <button type="submit" class="btn btn-primary">Save and Submit</button>
                        </div>
                    </div>
                </form>

            </div>
        </div>
    </div>
@endsection
