@extends('includes/layout')
@section('main-page-content')
<div class="container-xxl flex-grow-1 container-p-y">
    <div class="card mb-4">
        <div class="card-body">
            <div class="border-bottom py-2 pt-0 d-flex justify-content-between align-items-center">
                <div>
                    <small>Dashboard - Site</small>
                </div>
            </div>
            <div class="row mt-3">
                <div class="col-lg-7 col-md-12 pt-0 p-4 border-end site-detail">
                   <div class="d-flex justify-content-between">
                <h4 class="text-primary">{{$site->title ?? 'Global Site'}}</h4>
            </div>
                    <div class="h-6">Address:</div>
                    <div class="text_color">{{$site->street_address ?? ''}}</div>
                    <div class="h-6 mt-3">Area Radius:</div>

                    <div class="h3 text_color">{{ $site->area_radius ?? '' }}<span class="text-danger h6 fw-bold">(KM)</span></div>
                    <div id="map" class="shadow rounded" style="height: 650px;"></div>
                </div>

                <div class="col-lg-5 col-md-12 pt-0 p-4">
                    <div class="d-flex justify-content-between">
                        <div class="h6">About:</div>
                        <div>
                            @if($site->active == 1)
                            <span class="badge bg-success rounded-pill">Active</span>
                            @else
                            <span class="badge bg-secondary rounded-pill">Inactive</span>
                            @endif
                        </div>

                    </div>
                    {{-- <div class="border border-warning mb-3 w-px-300 p-1 borderd_div"> --}}
                      
                    {{-- </div> --}}

                    <div class="border mb-3 p-4 border-primary h-px-100 w-auto borderd_div">
                        <div class="d-flex">
                            <h6 >Created By:</h6>
                            <div class="h6 ms-1 m-0 mb-2 text-primary cursor-pointer" onclick="openInNewTab('{{ url('/') }}/user-profile/{{ $emppersonal->id ?? '' }}')">{{$emppersonal->first_name}} {{$emppersonal->middle_name}} {{$emppersonal->last_name}}</div>
                        </div>
                        <div class="created-at">
                            <h6>Created At: {{ optional($site->created_at)->format('d-M-Y') ?? '' }}</h6>
                        </div>
                    </div>
                    <div class="border mb-3 p-2 ps-4 border-primary  h-px-50 w-auto borderd_div">
                        <div class="d-flex align-items-lg-center">
                            <h6 class="mb-2 create_by_site">Supervisor:</h6>
                            <div class="border rounded-circle ms-2 border-primary mb-2 h-px-30 w-px-30" style="background:url('{{url($empsuper->image ?: '')}}'); background-size: cover; background-position: center;"></div>
                            <div class="h6 ms-1  mb-2 text-primary site_title cursor-pointer"
                            onclick="openInNewTab('{{ url('/') }}/user-profile/{{ $empsuper->id }}')"
                            >{{$empsuper->first_name}} {{$empsuper->middle_name}} {{$empsuper->last_name}}</div>
                        </div>
                    </div>
                    <div class="h6 mt-3">Descripton:</div>
                    <p class="text_color">{{$site->description ?? ''}}</p>
                    @if (!$sitehistories->isEmpty())
                    <h6 class="mt-3">History:</h6>
                    <div class="p-1 h-px-250 overflow-auto">
                        @foreach($sitehistories as $index => $sitehistorie)
                        <div class="history-box" style="{{ $loop->last ? 'border-color: transparent;' : '' }}">
                            <div class="history-tagline">
                                {!! $sitehistorie->description !!}
                            </div>
                            <div class="history-timestamp">
                                {{ \Carbon\Carbon::parse($sitehistorie->created_at)->format('d-M-Y | h:i A') }}
                            </div>
                            <div class="history-circle {{ $loop->first ? 'history-circle-active' : '' }}"></div>
                        </div>
                    @endforeach

                    @endif
                </div>

            </div>
        </div>
    </div>
</div>

@endsection
@section('css-js')
<script
src="https://maps.googleapis.com/maps/api/js?key=AIzaSyB7aLtWqhztn7r4Fcce7WqQT-Qdlpl7MnQ&callback=initMap&v=weekly"
async defer>
</script>


<script>
    function openInNewTab(url) {
    window.open(url, '_blank');
}
const citymap = {
vancouver: {
    center: { lat: {{$site->latitude}}, lng: {{$site->longitude}} },
    population: parseFloat({{$site->area_radius}}) || 0.1, // Use the provided area radius or default to 0.1
    borderColor: 'blue',
    fillColor: 'green',
    circle: null,
    marker: null,
},
};

let marker;

function initMap() {
const map = new google.maps.Map(document.getElementById('map'), {
    zoom: 17,
    center: citymap.vancouver.center,
    mapTypeId: 'terrain',
});

// Initialize marker at the center
marker = new google.maps.Marker({
    position: citymap.vancouver.center,
    map: map,
    draggable: true,
});

marker.addListener('dragend', function() {
    const position = marker.getPosition();
    document.getElementById('pro_longi').value = position.lng().toFixed(6);
    document.getElementById('project_latitude').value = position.lat().toFixed(6);
});

// Initialize circle with the provided or default area radius
citymap.vancouver.circle = new google.maps.Circle({
    strokeColor: citymap.vancouver.borderColor,
    strokeOpacity: 0.8,
    strokeWeight: 2,
    fillColor: citymap.vancouver.fillColor,
    fillOpacity: 0.35,
    map,
    center: citymap.vancouver.center,
    radius: citymap.vancouver.population * 1000,
});

const areaRadiusInput = document.getElementById('pro_area_radius');
areaRadiusInput.addEventListener('input', function() {
    const newPopulation = parseFloat(areaRadiusInput.value) || 0.8;

    // Update both the marker and the circle radius dynamically
    marker.setMap(map);
    citymap.vancouver.population = newPopulation;
    citymap.vancouver.circle.setRadius(newPopulation * 1000);
});
}

window.initMap = initMap;


</script>


<style>
    @media screen and (max-width: 320px){
.site_title {
    margin-top: -8px !important;
}
.created-at{
    margin-top: -7px;
}
}
</style>



@endsection
