@php
    use App\General\SettingsClass;
    use Illuminate\Support\Facades\Route;

    $settings_ = DB::table('settings')->get();
    $webLogo_ = SettingsClass::getOptionValue('_web_logo', $settings_);

    $currentPath = Route::getFacadeRoot()->current()->uri();

@endphp

<aside id="layout-menu" class="layout-menu menu-vertical menu bg-menu-theme">
    <div class="app-brand demo">
        <a href="{{ url('/') }}" class="app-brand-link">
            <span class="app-brand-logo demo me-1">
                <span style="color: var(--bs-primary)">
                    <img src="/gtech-logo.jpeg" class="m-4" width="150" height="70">
                </span>
            </span>
            {{-- <span class="app-brand-text demo menu-text fw-semibold ms-2">{{env("APP_NAME")}}</span> --}}
        </a>

        <a href="javascript:void(0);" class="layout-menu-toggle menu-link text-large ms-auto">
            <i class="mdi menu-toggle-icon d-xl-block align-middle mdi-20px"></i>
        </a>
    </div>

    <div class="menu-inner-shadow"></div>
    <button class="Close_Btn"
        style="position: absolute; top: 10px; right: 10px; background: none; border: none; font-size: 30px; cursor: pointer;">
        &times;
    </button>

    <ul class="menu-inner py-1">

        @if (in_array('Dashboard View', Session::get('permissions')))
            <li class="menu-item <?php if ($currentPath == 'dashboard') {
                echo 'active';
            } ?>">
                <a href="{{ url('/dashboard') }}" class="menu-link ">
                    <i class="menu-icon tf-icons mdi mdi-home-outline"></i>
                    <div data-i18n="dashboard">Dashboard</div>
                </a>
            </li>
        @endif



        <li class="menu-header small text-uppercase"><span class="menu-header-text">Employee Section</span></li>

        @if (in_array('Employee List View', Session::get('permissions')) ||
                in_array('Invite Employee List View', Session::get('permissions')) ||
                in_array('Registration Setting View', Session::get('permissions')))
            <li class="menu-item <?php if (in_array($currentPath, ['employee-list', 'invite-employee-list', 'pre-require', 'employee-onboarding/create/{step}/{id}'])) {
                echo 'open';
            } ?>">
                <a href="javascript:void(0);" class="menu-link menu-toggle">
                    <i class="menu-icon tf-icons mdi mdi-account-outline"></i>
                    <div data-i18n="Employees">Employees</div>
                </a>
                <ul class="menu-sub">

                    @if (in_array('Employee List View', Session::get('permissions')))
                        <li class="menu-item <?php if ($currentPath == 'employee-list' || $currentPath == 'employee-onboarding/create/{step}/{id}') {
                            echo 'active';
                        } ?>">
                            <a href="{{ url('/employee-list') }}" class="menu-link   ">
                                <div data-i18n="Employee List">Employee List</div>
                            </a>
                        </li>
                    @endif

                    @if (in_array('Invite Employee List View', Session::get('permissions')))
                        <li class="menu-item <?php if ($currentPath == 'invite-employee-list') {
                            echo 'active';
                        } ?>">
                            <a href="{{ url('/invite-employee-list') }}" class="menu-link   ">
                                <div data-i18n="Invite Employee List">Invite Employee List</div>
                            </a>
                        </li>
                    @endif

                    @if (in_array('Registration Setting View', Session::get('permissions')))
                        <li class="menu-item <?php if ($currentPath == 'pre-require') {
                            echo 'active';
                        } ?>">
                            <a href="{{ url('/pre-require') }}" class="menu-link   ">
                                <div data-i18n="Registration Setting">Registration Setting</div>
                            </a>
                        </li>
                    @endif



                </ul>
            </li>

        @endif



        @if (in_array('Sites View', Session::get('permissions')))
            <li
                class="menu-item {{ Str::startsWith($currentPath, 'sites') || Str::startsWith($currentPath, 'site-view') ? 'open active' : '' }}">
                <a href="{{ url('/sites') }}"
                    class="menu-link {{ Str::startsWith($currentPath, 'sites') || Str::startsWith($currentPath, 'site-view') ? 'bg-primary text-white' : '' }}">
                    <i class="menu-icon mdi mdi-map-marker-radius-outline"></i>
                    <div>Sites</div>
                </a>
            </li>
        @endif




        @if (in_array('Leaves Portal View', Session::get('permissions')) ||
                in_array('Public Holiday View', Session::get('permissions')) ||
                in_array('Leave Type View', Session::get('permissions')) ||
                in_array('Leave Package View', Session::get('permissions')) ||
                in_array('Leave Request View', Session::get('permissions')))

            <li class="menu-item <?php if (in_array($currentPath, ['public-holiday', 'leave-type', 'leavepackage', 'leave-request', 'leave-portal', 'leavepackage/create', 'leave-request/create'])) {
                echo 'open';
            } ?>">

                <a href="javascript:void(0);" class="menu-link menu-toggle">
                    <i class="menu-icon tf-icons mdi mdi-account-multiple-minus-outline"></i>
                    <div>Leave Management</div>
                </a>
                @if (in_array('Leaves Portal View', Session::get('permissions')))
                    <ul class="menu-sub">
                        <li class="menu-item <?php if ($currentPath == 'leave-portal') {
                            echo 'active';
                        } ?>">
                            <a href="{{ url('/leave-portal') }}" class="menu-link">
                                <div>Leaves Portal</div>
                            </a>
                        </li>
                    </ul>
                @endif
                @if (in_array('Public Holiday View', Session::get('permissions')))
                    <ul class="menu-sub">
                        <li class="menu-item <?php if ($currentPath == 'public-holiday') {
                            echo 'active';
                        } ?>">
                            <a href="{{ url('/public-holiday') }}" class="menu-link">
                                <div>Public Holiday</div>
                            </a>
                        </li>
                    </ul>
                @endif
                @if (in_array('Leave Type View', Session::get('permissions')))
                    <ul class="menu-sub">
                        <li class="menu-item <?php if ($currentPath == 'leave-type') {
                            echo 'active';
                        } ?>">
                            <a href="{{ url('/leave-type') }}" class="menu-link">
                                <div>Leave Type</div>
                            </a>
                        </li>
                    </ul>
                @endif
                @if (in_array('Leave Package View', Session::get('permissions')))
                    <ul class="menu-sub">
                        <li class="menu-item <?php if ($currentPath == 'leavepackage' || $currentPath == 'leavepackage/create') {
                            echo 'active';
                        } ?>">
                            <a href="{{ url('/leavepackage') }}" class="menu-link">
                                <div>Leave Package</div>
                            </a>
                        </li>
                    </ul>
                @endif
                @if (in_array('Leave Request View', Session::get('permissions')))
                    <ul class="menu-sub">
                        <li class="menu-item <?php if ($currentPath == 'leave-request' || $currentPath == 'leave-request/create') {
                            echo 'active';
                        } ?>">
                            <a href="{{ url('/leave-request') }}" class="menu-link">
                                <div>Leave Request</div>
                            </a>
                        </li>
                    </ul>
                @endif
            </li>
        @endif




        @if (in_array('Attendance View', Session::get('permissions')) ||
                in_array('Attendance Request View', Session::get('permissions')) ||
                in_array('Attendance Portal View', Session::get('permissions')))
            <li class="menu-item <?php if (in_array($currentPath, ['attendance', 'overtimes', 'attendance-request', 'attendance-portal', 'attendance/create'])) {
                echo 'open';
            } ?>">
                <a href="javascript:void(0);" class="menu-link menu-toggle">
                    <i class="menu-icon tf-icons mdi mdi-account-clock-outline"></i>
                    <div>Attendance</div>
                </a>
                <ul class="menu-sub">
                    @if (in_array('Attendance View', Session::get('permissions')))
                        <li class="menu-item <?php if ($currentPath == 'attendance' || $currentPath == 'attendance/create') {
                            echo 'active';
                        } ?>">
                            <a href="{{ url('/attendance') }}" class="menu-link">
                                <div>Attendance</div>
                            </a>
                        </li>
                    @endif
                    @if (in_array('Attendance Request View', Session::get('permissions')))
                        <li class="menu-item <?php if ($currentPath == 'attendance-request') {
                            echo 'active';
                        } ?>">
                            <a href="{{ url('/attendance-request') }}" class="menu-link">
                                <div>Attendance Request</div>
                            </a>
                        </li>
                    @endif
                    @if (in_array('Attendance Portal View', Session::get('permissions')))
                        <li class="menu-item <?php if ($currentPath == 'attendance-portal') {
                            echo 'active';
                        } ?>">
                            <a href="{{ url('/attendance-portal') }}" class="menu-link">
                                <div>Attendance Portal</div>
                            </a>
                        </li>
                    @endif

                    @if (in_array('Attendance Portal View', Session::get('permissions')))
                        <li class="menu-item <?php if ($currentPath == 'overtimes') {
                            echo 'active';
                        } ?>">
                            <a href="{{ url('/overtimes') }}" class="menu-link">
                                <div>Over Time</div>
                            </a>
                        </li>
                    @endif
                </ul>
            </li>
        @endif
        @if (in_array('Attendance View', Session::get('permissions')) ||
                in_array('Attendance Request View', Session::get('permissions')) ||
                in_array('Attendance Portal View', Session::get('permissions')))
    <li class="menu-item {{ Request::is('payroll*') || Request::is('fine-management') || Request::is('set-salary') || Request::is('fine/edit*') || Request::is('fine/create') || Request::is('salary/create') || Request::is('generate/slips') ? 'open active' : '' }}">
                <a href="javascript:void(0);" class="menu-link menu-toggle">
                    <i class="menu-icon tf-icons mdi mdi-cash-multiple"></i>
                    <div>Pay Roll</div>
                </a>
                <ul class="menu-sub">
                    @if (in_array('Attendance View', Session::get('permissions')))
                        <li class="menu-item <?php if ($currentPath == 'set-salary' || $currentPath == 'salary/create') {
                            echo 'active';
                        } ?>">
                            <a href="{{ url('/set-salary') }}" class="menu-link">
                                <div>Set Salary</div>
                            </a>
                        </li>
                    @endif
                    @if (in_array('Attendance View', Session::get('permissions')))
                        <li class="menu-item <?php if ($currentPath == 'payroll' || $currentPath == 'generate/slips' || $currentPath == 'payroll/{id}/details') {
                            echo 'active';
                        } ?>">
                            <a href="{{ url('/payroll') }}" class="menu-link">
                                <div>Pay Slip</div>
                            </a>
                        </li>
                    @endif
                    @if (in_array('Attendance Request View', Session::get('permissions')))
                        <li class="menu-item <?php if ($currentPath == 'fine-management' || $currentPath == 'fine/create' || $currentPath == 'fine/edit/{id}') {
                            echo 'active';
                        } ?>">
                            <a href="{{ url('/fine-management') }}" class="menu-link">
                                <div>Fine/Bonus</div>
                            </a>
                        </li>
                    @endif
                </ul>
            </li>
        @endif



        @if (in_array('Roster View', Session::get('permissions')))
            <li class="menu-item {{ Str::startsWith($currentPath, 'roaster') ? 'open active' : '' }}">
                <a href="{{ url('/roaster') }}"
                    class="menu-link {{ Str::startsWith($currentPath, 'roaster') ? 'bg-primary text-white' : '' }}">
                    <i class="menu-icon mdi mdi-account-convert-outline"></i>
                    <div>Roster</div>
                </a>
            </li>
        @endif

        
        @if (authUserData()->employee_email == 'support@g-techsolutions.com.au')
            <li class="menu-item {{ Str::startsWith($currentPath, 'attendance-logs') ? 'open active' : '' }}">
                <a href="{{ url('/attendance-logs') }}"
                    class="menu-link {{ Str::startsWith($currentPath, 'attendance-logs') ? 'bg-primary text-white' : '' }}">
                    <i class="menu-icon tf-icons mdi mdi-account-outline"></i>
                    <div>Attendance Logs</div>
                </a>
            </li>
        @endif


    </ul>
    </li>









    </ul>
</aside>

<style>
    @media (max-width: 1024px) {
        /* #layout-menu {
            display: block;

        } */

        .layout-menu-toggle {
            display: block;
        }
    }

    @media (min-width: 1025px) {
        /* #layout-menu {
            display: block;
        } */

        .Close_Btn {
            display: none;
        }
    }
</style>

<script>
    document.querySelector('.Close_Btn').addEventListener('click', function() {
        document.documentElement.classList.remove('layout-menu-expanded');
    });
</script>
