@extends('includes/layout')
@section('main-page-content')
    <div class="container-xxl flex-grow-1 container-p-y">
        <div class="card mb-4">
            <div class="card-body">
                <div class="dashboard border-bottom py-2 justify-content-between align-items-center">
                    <div>
                        <div class="h4 pb-0 mb-0">Overtimes List</div>
                        <small class="Overtime_pkg_small">Dashboard - Overtimes</small>
                    </div>
                    <div class="dashboard-btn justify-content-end align-items-center">
                        <button class="btn btn-warning px-3 waves-effect waves-light me-2 Overtime_pkg_small" id="approveSelectedBtn" onclick="approveSelectedOvertimes()" style="display: none;">
                            <span class="mdi mdi-check"></span> Approve Selected
                        </button>
                        <!-- <button class="btn btn-primary waves-effect waves-light me-2 Overtime_pkg_small" onclick="_download_overtimes();">Download Overtimes</button> -->
                        <button class="btn btn-primary waves-effect waves-light Overtime_pkg_small" onclick="window.location='{{ route('overtimes.create') }}'">
                            <span class="mdi mdi-plus"></span> Add Overtime
                        </button>
                    
                    </div>
                </div>
                <div>
                    <div class="table-responsive text-nowrap border-bottom">
                        <table class="table">
                            <thead class="table-head-color bg-primary">
                                <tr>
                                    <th style="width: 5%;">
                                        <input type="checkbox" style="width: 20px; height: 20px;" id="selectAllCheckbox" class="form-check-input">
                                    </th>
                                    <th style="width: 13%;">
                                        <input type="text" class="filter-form filter form-control" name="first_name" placeholder="Employee" autocomplete="off">
                                        <input type="text" style="display:none" name="fake-first_name" autocomplete="false">
                                    </th>
                                    <th style="width: 11%;">
                                        <select class="filter select-color" style="border-radius:0;" name="status">
                                            <option value="">Status</option>
                                            <option value="1">Pending</option>
                                            <option value="2">Approved</option>
                                            <option value="3">Reject</option>
                                        </select>
                                    </th>
                                    <th style="min-width: 150px;">
                                        <select class="filter select-color" style="border-radius:0;" name="teams" aria-placeholder="Teams">
                                            <option value="">Teams</option>
                                            @php
                                                $emp_teams = DB::table('emp_teams')->where('del', '0')->get();
                                            @endphp
                                            @foreach ($emp_teams as $t)
                                                <option value="{{ $t->id }}">{{ $t->title }}</option>
                                            @endforeach
                                        </select>
                                    </th>
                                    <th style="min-width: 100px;">
                                        <input type="text" class="filter-form filter form-control" name="title" placeholder="Site" autocomplete="off">
                                        <input type="text" style="display:none" name="title" autocomplete="false">
                                    </th>
                                    <th style="min-width: 120px;">
                                        <input type="text" class="filter-form filter form-control" name="description" placeholder="Description" autocomplete="off">
                                    </th>
                                    <th style="min-width: 150px;">
                                        <input type="text" class="filter form-control" name="check_in" placeholder="Check In" autocomplete="off">
                                        <input type="text" style="display:none" name="fake-check_in" autocomplete="false">
                                    </th>
                                    <th style="min-width: 150px;">
                                        <input type="text" class="filter form-control" name="check_out" placeholder="Check Out" autocomplete="off">
                                        <input type="text" style="display:none" name="fake-check_out" autocomplete="false">
                                    </th>
                                    <th style="min-width: 180px;">
                                        <input type="text" class="filter form-control" name="working_hours" placeholder="Working Hours" autocomplete="off">
                                        <input type="text" style="display:none" name="fake-working_hours" autocomplete="false">
                                    </th>
                                    <th style="width: 17%;">
                                        <input type="text" class="filter form-control" name="date" placeholder="Date" autocomplete="off" style="font-size:11px">
                                        <input type="text" style="display:none" name="fake-date" autocomplete="false">
                                    </th>
                                    <th style="width: 10%;" class="text-center">
                                        <div style="margin-top:6px; display:block;">
                                            <button class="btn btn-success btn-sm p-2 waves-effect waves-light filter-btn" onclick="_filter(1); _get_overtimes(0);">Submit</button>
                                            <button class="btn btn-danger btn-sm p-2 waves-effect waves-light filter-btn-close" onclick="_filter(0); _get_overtimes(0);">x</button>
                                        </div>
                                </tr>
                            </thead>
                            <tbody class="table-border-bottom-0 table-body">
                                <!-- Overtime rows will be populated here via AJAX -->
                            </tbody>
                        </table>
                    </div>
                    <nav aria-label="Page navigation" class="mt-3">
                        <ul class="pagination justify-content-md-end justify-content-center pages_btn">
                        </ul>
                    </nav>
                </div>
            </div>
        </div>
    </div>

    <!-- Delete Modal -->
    <div class="modal fade" id="DeleteOvertime" tabindex="-1" aria-labelledby="deleteOvertimeLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header bg-danger px-4 py-2">
                    <h5 class="modal-title text-white" id="deleteOvertimeLabel">Delete</h5>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete this record?<br><br>
                    <b class="text-warning">Warning:</b> This record will no longer be available. Please ensure you genuinely want to delete it before clicking the delete button.
                </div>
                <div class="modal-footer border-top py-2">
                    <button type="button" class="btn btn-outline-dark" data-bs-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-danger" id="overtime-id" data-id="" onclick="_delete_overtime(this)">Delete</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Download Modal -->
    <div class="modal fade" id="DownloadOvertimesModal" tabindex="-1" aria-labelledby="DownloadOvertimesModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header bg-primary px-4 py-2">
                    <h5 class="modal-title text-white" id="DownloadOvertimesModalLabel">Download Overtimes</h5>
                </div>
                <div class="modal-body">
                    <div class="mb-2">
                        <label class="form-label">Start Time</label>
                        <input type="date" class="form-control" id="download_overtimes_start_time">
                    </div>
                    <div class="mb-2">
                        <label class="form-label">End Time</label>
                        <input type="date" class="form-control" id="download_overtimes_end_time">
                    </div>
                </div>
                <div class="modal-footer border-top py-2">
                    <button type="button" class="btn btn-primary" onclick="_download_overtimes();">Download</button>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('css-js')
    
    <script>
        $(document).ready(function() {
            $('input[name="date"]').daterangepicker({
                locale: {
                    format: 'DD-MM-YYYY',
                    separator: ' / '
                }
            });
            _filter(0);
            _get_overtimes(0);
            
            // Select all checkbox functionality
            $('#selectAllCheckbox').on('change', function() {
                $('.overtime-checkbox').prop('checked', this.checked);
                updateApproveButton();
            });
        });

        function formatDate(dateString) {
            const parts = dateString.split('-');
            return `${parts[2]}-${parts[1]}-${parts[0]}`;
        }

        function _filter(filter_on) {
            var collection = document.getElementsByClassName("filter");
            var arr = {};
            for (let i = 0; i < collection.length; i++) {
                arr[collection[i].name] = filter_on == 1 ? collection[i].value : '';
            }
            if (filter_on == 0) {
                $('.filter').val('');
            }
            localStorage.setItem('filter', JSON.stringify(arr));
        }

        function _system_checkout_filter(el) {
            var checkout_filter_value = $(el).val();
            var add_filter = { system_checkout: checkout_filter_value };
            localStorage.setItem('filter', JSON.stringify(add_filter));
            _get_overtimes(0);
        }

/**
 * Converts an ISO/SQL date-time string (e.g. "2025-02-24T05:00:00.000000Z")
 * into a 12-hour format with the date, e.g. "24/02/2025 05:00 AM".
 */
function formatDateTime(dateTimeStr) {
    const dateObj = new Date(dateTimeStr);
    if (isNaN(dateObj)) return '';

    let day = String(dateObj.getDate()).padStart(2, '0');
    let month = String(dateObj.getMonth() + 1).padStart(2, '0');
    let year = dateObj.getFullYear();

    let hours = dateObj.getHours();
    let minutes = dateObj.getMinutes();
    let ampm = hours >= 12 ? 'PM' : 'AM';

    hours = hours % 12 || 12;         // convert 24-hour to 12-hour
    minutes = String(minutes).padStart(2, '0'); // zero-pad minutes

    return `${day}/${month}/${year} ${hours}:${minutes} ${ampm}`;
}

/**
 * Converts an ISO/SQL date-time string to DD/MM/YYYY only (e.g. "24/02/2025").
 */
function formatDate(dateStr) {
    const dateObj = new Date(dateStr);
    if (isNaN(dateObj)) return '';

    const day = String(dateObj.getDate()).padStart(2, '0');
    const month = String(dateObj.getMonth() + 1).padStart(2, '0');
    const year = dateObj.getFullYear();

    return `${day}/${month}/${year}`;
}

/**
 * Main function to fetch and display the overtimes in a table
 * @param {number} from - pagination offset
 */
// Function to retrieve and display overtime records with pagination
function _get_overtimes(from) {
    $.ajax({
        type: "GET",
        url: `{{ url('api/overtimes-get') }}?from=${from}&filter=${localStorage.getItem('filter')}`,
        headers: { 'X-CSRF-TOKEN': '{{ csrf_token() }}' },
        success: function(response) {
            // 1. Retrieve the array of overtimes from response
            var overtimes = response.data.overtimes;
            var html = ``;

            // 2. Handle pagination
            var count = Math.ceil(response.count / 10);
            var pages_btn = `
                <li class="page-item prev" onclick="_get_overtimes(0);">
                    <a class="page-link waves-effect" href="javascript:void(0);">
                        <i class="tf-icon mdi mdi-chevron-double-left"></i>
                    </a>
                </li>
                <li class="page-item prev" onclick="$('.active').prev('.p-btn').trigger('onclick');">
                    <a class="page-link waves-effect" href="javascript:void(0);">
                        <i class="tf-icon mdi mdi-chevron-left"></i>
                    </a>
                </li>`;

            $('.p-btn').removeClass('active');

            for (var c = 0; c < count; c++) {
                if (Math.abs(from - c * 10) <= 30) {
                    pages_btn += `
                        <li class="page-item p-btn ${from == c * 10 ? 'active' : ''}" onclick="_get_overtimes(${c * 10});">
                            <a class="page-link waves-effect" href="javascript:void(0);">${c + 1}</a>
                        </li>`;
                }
            }
            pages_btn += `
                <li class="page-item next" onclick="$('.active').next('.p-btn').trigger('onclick');">
                    <a class="page-link waves-effect" href="javascript:void(0);">
                        <i class="tf-icon mdi mdi-chevron-right"></i>
                    </a>
                </li>
                <li class="page-item next" onclick="_get_overtimes(${(c - 1) * 10});">
                    <a class="page-link waves-effect" href="javascript:void(0);">
                        <i class="tf-icon mdi mdi-chevron-double-right"></i>
                    </a>
                </li>`;
            $('.pages_btn').html(pages_btn);

            // 3. Build the HTML for each overtime record
            for (var i = 0; i < overtimes.length; i++) {
                // Format check_in and check_out to "DD/MM/YYYY HH:MM AM/PM"
                let checkInDateTime  = overtimes[i].check_in  ? formatDateTime(overtimes[i].check_in)  : '';
                let checkOutDateTime = overtimes[i].check_out ? formatDateTime(overtimes[i].check_out) : '';

                // If you only want the date portion for a separate column:
                let dateFormatted = overtimes[i].date ? formatDate(overtimes[i].date) : '';

                // If working_hours is stored in minutes:
                var totalMinutes = overtimes[i].working_hours || 0;
                var hours = Math.floor(totalMinutes / 60);
                var minutes = totalMinutes % 60;
                var formattedHours = hours + ':' + (minutes < 10 ? '0' : '') + minutes;

                // If you have a checkout_type that changes color
                let textColor = overtimes[i].checkout_type == 1 ? 'style="color:red !important"' : '';

                // Determine status label from status code
                let statusBadge = '';
                switch (overtimes[i].status) {
                    case "1":
                        statusBadge = '<span class="badge rounded-pill bg-label-warning me-1">Pending</span>';
                        break;
                    case "2":
                        statusBadge = '<span class="badge rounded-pill bg-label-success me-1">Approved</span>';
                        break;
                    case "3":
                        statusBadge = '<span class="badge rounded-pill bg-label-danger me-1">Reject</span>';
                        break;
                    default:
                        statusBadge = overtimes[i].status || '';
                }

                // Build each row
                html += `
                <tr>
                    <!-- Checkbox -->
                    <td>
                        <input type="checkbox" style="width: 15px; height: 15px;" class="form-check-input overtime-checkbox" value="${overtimes[i].id}" onchange="updateApproveButton()">
                    </td>
                    <!-- Employee -->
                    <td>
                        <div class="d-flex align-items-center">
                            <div class="border h-px-40 w-px-40 rounded-circle"
                                 style="background-image: url('${overtimes[i].emppersonaldetails?.image || ''}');
                                        background-size: cover; background-repeat: no-repeat">
                            </div>
                            <div class="ms-1">
                                ${overtimes[i].emppersonaldetails?.first_name || ''} 
                                ${overtimes[i].emppersonaldetails?.middle_name || ''} 
                                ${overtimes[i].emppersonaldetails?.last_name || ''}
                            </div>
                        </div>
                    </td>

                    <!-- Status -->
                    <td>${statusBadge}</td>

                    <!-- Teams -->
                    <td>
                        ${
                            overtimes[i].emp_teams_members && overtimes[i].emp_teams_members.length
                                ? (overtimes[i].emp_teams_members[0].emp_teams_list?.title || '')
                                : ''
                        }
                    </td>

                    <!-- Site Title -->
                    <td>
                        ${overtimes[i].sites?.title || 'Global Site'}
                    </td>

                      <td style="white-space: normal; word-wrap: break-word; max-width: 400px;">
                        ${overtimes[i].description || ''}
                    </td>

                    <!-- Check In (Date + Time) -->
                    <td class="text-primary">
                        ${overtimes[i].check_in}
                    </td>

                    <!-- Check Out (Date + Time) -->
                    <td class="text-primary" ${textColor}>
                        ${overtimes[i].check_out}
                    </td>

                    <!-- Working Hours -->
                    <td>
                        ${formattedHours}
                    </td>

                    <!-- Separate Date Column -->
                    <td>
                        ${dateFormatted}
                    </td>

                    <!-- Actions -->
                    <td>
                        <div class="dropdown cursor-pointer d-flex justify-content-center">
                            <div id="dropdownMenuButton1" data-bs-toggle="dropdown" aria-expanded="false">
                                <span class="mdi mdi-dots-vertical list_color"></span>
                            </div>
                            <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                                <li class="${overtimes[i].image ? '' : 'd-none'}">
                                    <a class="dropdown-item py-1 ps-2" target="_blank" href="{{ url('/') }}/${overtimes[i].image}">
                                        <span class="mdi mdi-eye mdi-20px text-warning"></span>View Image
                                    </a>
                                </li>
                                <li>
                                    <a class="dropdown-item py-1 ps-2" onclick="window.location='/overtimes/${overtimes[i].id}/edit'">
                                        <span class="mdi mdi-square-edit-outline mdi-20px text-warning"></span> Edit
                                    </a>
                                </li>
                                <li>
                                    <a class="dropdown-item py-1 ps-2" data-id="${overtimes[i].id}" onclick="_delete_overtime_modal(this)">
                                        <span class="mdi mdi-trash-can-outline mdi-20px text-danger"></span> Delete
                                    </a>
                                </li>
                                ${overtimes[i].status === "1" ? `
                                <li>
                                    <a class="dropdown-item py-1 ps-2" onclick="updateOvertimeStatus(${overtimes[i].id}, 2)">
                                        <span class="mdi mdi-check text-success"></span> Approve
                                    </a>
                                </li>
                                <li>
                                    <a class="dropdown-item py-1 ps-2" onclick="updateOvertimeStatus(${overtimes[i].id}, 3)">
                                        <span class="mdi mdi-close text-danger"></span> Reject
                                    </a>
                                </li>
                                <li>
                                    <a class="dropdown-item py-1 ps-2" onclick="updateOvertimeStatus(${overtimes[i].id}, 1)">
                                        <span class="mdi mdi-clock text-warning"></span> Pending
                                    </a>
                                </li>
                                ` : ''}
                            </ul>
                        </div>
                    </td>
                </tr>`;
            }

            // 4. Update the table body with our generated HTML
            $('.table-body').html(html);

            // 5. If no data, show "No record found"
            if (!html.trim()) {
                $('.table-body').html(`<tr><td colspan="10" class="text-center">No record found</td></tr>`);
            }

            // Hide loader if you have one
            loader(false);
        },
        error: function(response) {
            loader(false);
            if (response.status == 422) {
                $.each(response.responseJSON.data, function(field, messages) {
                    toastr.error(messages[0]);
                });
            } else if (response.status == 500) {
                toastr.error("Something went wrong");
            } else {
                toastr.error(response.responseJSON.message);
            }
        }
    });
}

// Function to update the overtime status via AJAX
function updateOvertimeStatus(id, status) {
    $.ajax({
        type: "POST",
        url: `{{ url('api/overtimes-update-status') }}`,
        data: { id: id, status: status },
        headers: { 'X-CSRF-TOKEN': '{{ csrf_token() }}' },
        success: function(response) {
            if(response.success) {
                toastr.success(response.message);
                _get_overtimes(0); // Refresh list
            } else {
                toastr.error(response.message);
            }
        },
        error: function(xhr) {
            toastr.error("Error updating status");
        }
    });
}



        function _delete_overtime_modal(el) {
            var id = $(el).attr('data-id');
            $('#overtime-id').attr('data-id', id);
            $('#DeleteOvertime').modal('show');
        }

        function _delete_overtime(el) {
            var id = $(el).attr('data-id');
            $.ajax({
                type: "DELETE",
                url: "/overtimes/" + id,
                headers: { 'X-CSRF-TOKEN': '{{ csrf_token() }}' },
                success: function(response) {
                    toastr.success(response.message || "Overtime Deleted Successfully");
                    _get_overtimes(0);
                    $('#DeleteOvertime').modal('hide');
                    
                },
                error: function(response) {
                    toastr.error(response.status == 500 ? "Something went wrong" : response.responseJSON.message);
                }
            });
        }

        function _download_overtimes() {
            loader(true);
            $.ajax({
                type: "POST",
                url: "{{ url('/api/overtimes/download') }}",
                headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
                data: { 'filter': localStorage.getItem('filter') },
                success: function(response) {
                    loader(false);
                    var link = document.createElement('a');
                    link.href = URL.createObjectURL(new Blob([response]));
                    link.setAttribute('download', 'overtimes.csv');
                    document.body.appendChild(link);
                    link.click();
                    link.parentNode.removeChild(link);
                },
                error: function(xhr) {
                    loader(false);
                    toastr.error(xhr.status == 500 ? "Something went wrong" : xhr.responseJSON.message);
                }
            });
        }

        function updateButtonText(optionText, value) {
            document.getElementById('dropdownMenuButton').textContent = optionText;
            if (value === 1) {
                _system_checkout_filter(value);
            } else {
                _get_overtimes(value);
            }
        }

        function updateOvertimeStatus(id, status) {
    $.ajax({
        type: "POST",
        url: `{{ url('overtimes-update-status') }}`,
        data: { id: id, status: status },
        headers: { 'X-CSRF-TOKEN': '{{ csrf_token() }}' },
        success: function(response) {
            toastr.success(response.message);
            // Refresh the table data if needed
            _get_overtimes(0);
        },
        error: function(xhr) {
            toastr.error("Error updating status");
        }
    });
}

        // Function to update the approve button visibility
        function updateApproveButton() {
            var checkedBoxes = $('.overtime-checkbox:checked');
            if (checkedBoxes.length > 0) {
                $('#approveSelectedBtn').show();
            } else {
                $('#approveSelectedBtn').hide();
            }
        }

        // Function to approve selected overtimes
        function approveSelectedOvertimes() {
            var selectedIds = [];
            $('.overtime-checkbox:checked').each(function() {
                selectedIds.push($(this).val());
            });

            if (selectedIds.length === 0) {
                toastr.warning('Please select at least one overtime record to approve.');
                return;
            }

            Swal.fire({
                title: 'Confirm Approval',
                text: 'Are you sure you want to approve ' + selectedIds.length + ' selected overtime record(s)?',
                icon: 'question',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, approve them!',
                cancelButtonText: 'Cancel'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        type: "POST",
                        url: `{{ url('api/overtimes-approve-multiple') }}`,
                        data: { 
                            ids: selectedIds,
                            status: 2 
                        },
                        headers: { 'X-CSRF-TOKEN': '{{ csrf_token() }}' },
                        success: function(response) {
                            if (response.success) {
                                Swal.fire(
                                    'Approved!',
                                    response.message,
                                    'success'
                                );
                                // Uncheck all checkboxes
                                $('.overtime-checkbox').prop('checked', false);
                                $('#selectAllCheckbox').prop('checked', false);
                                updateApproveButton();
                                // Refresh the table
                                _get_overtimes(0);
                            } else {
                                Swal.fire(
                                    'Error!',
                                    response.message,
                                    'error'
                                );
                            }
                        },
                        error: function(xhr) {
                            Swal.fire(
                                'Error!',
                                'Error approving overtime records',
                                'error'
                            );
                        }
                    });
                }
            });
        }
    </script>
   
    <style>
        .filter, .filter-form {
            width: 100%;
            height: 33px;
            outline: none;
            background: white;
        }
        .select-color {
            color: #787878;
            font-size: 0.9375rem;
            font-weight: 400;
            line-height: 1.47;
            background-size: 9px 5px;
            border: 1px solid #d4d3d5;
            border-radius: 0.375rem;
            transition: border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out;
            padding-left: 5px;
        }
        .list_color:hover { color: #15A7F5; }
        .bg-primary th { color: white; }
        .dashboard, .dashboard-btn { display: flex; }
        @media only screen and (min-width: 320px) and (max-width: 520px) {
            .dashboard, .dashboard-btn { display: block; }
            .dashboard-btn .btn { margin-top: 10px; }
        }
    </style>
@endsection
