<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Session;
use App\Http\Controllers\FormController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\SiteController;
use App\Http\Controllers\TierController;
use App\Http\Controllers\LeaveController;
use App\Http\Controllers\PopupController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\EmpTeamController;
use App\Http\Controllers\EmpTypeController;
use App\Http\Controllers\PayRollController;
use App\Http\Controllers\ProjectController;
use App\Http\Controllers\EmployeeController;
use App\Http\Controllers\OvertimeController;
use App\Http\Controllers\SettingsController;
use App\Http\Controllers\TrainingController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\EmpPermitController;
use App\Http\Controllers\AttendanceController;
use App\Http\Controllers\PreRequestController;
use App\Http\Controllers\PreRequireController;
use App\Http\Controllers\TierPackageController;
use App\Http\Controllers\LeavePackageController;
use App\Http\Controllers\LeaveRequestController;

// use App\Http\Controllers\NotificationController;
use App\Http\Controllers\EmpWorkerTypeController;
use App\Http\Controllers\LinkManagementController;
use App\Http\Controllers\RosterTemplateController;
use App\Http\Controllers\RequiredDocumentController;

use App\Http\Controllers\EmpWorkExperienceController;
use App\Http\Controllers\EmployeeOnboardingController;

use App\Http\Controllers\NotifiableClassificationController;
use App\Http\Controllers\RequiredExternalDocumentController;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/


Route::get('/clear-cache', function () {
    Artisan::call('cache:clear');
    Artisan::call('view:clear');
    Artisan::call('config:clear');
    Artisan::call('route:clear');
    return redirect('/?cache=cleared');
});



Route::post('/employee-list/change-col', [EmployeeController::class, 'changeCol']);
Route::post('/attendance-list/change-col', [AttendanceController::class, 'changeCol']);


Route::get('/', function () {

    if (Auth::user()) {
        return redirect('/dashboard');
    } else {
        return view('Auth.login');
    }
});


Route::middleware(['dashboard_auth'])->group(function () {

    Route::get('/dashboard', [DashboardController::class, 'index'])->middleware('Permissions:Dashboard View');
    Route::get('/get-expiring-document', [DashboardController::class, 'expiringDocuments']);
    Route::get('/get-missing-document', [DashboardController::class, 'missingDocuments']);
    Route::get('/get-absent-employees', [DashboardController::class, 'absentEmployees']);
    Route::get('/get-present-employees', [DashboardController::class, 'presentEmployees']);
    // Route::get('/notifications', [NotificationController::class, 'notificationFiltersData']);
    // Route::get('/notifications/create', [NotificationController::class, 'create'])->name('notification.create');
    // Route::post('/notifications/store', [NotificationController::class, 'store']);

    // Route::get('/get-custom-notifications', [NotificationController::class, 'customNotification']);

    Route::view('/no_permission', 'Permission/no_permission');
    Route::get('/user-profile/{id}', function () {
        return view('Employee.profile');
    });

    Route::get('/test-email-view', function () {
        return view('Emails.invite');
    });
    Route::get('/employee-profile-compeleted', function () {
        return view('Employee.NewEmployeeOnboarding.employeeProfileCompeleted');
    });
    Route::get('/employee-onboarding/create/{step}/{id}', function () {
        return view('Employee.NewEmployeeOnboarding.newEmployeeOnboarding');
    })->middleware('Permissions:Employee List Maintain');
    Route::get('/employee-list', function () {
        return view('Employee.employeeList');
    })->middleware('Permissions:Employee List View');
    Route::get('/invite-employee/create/{step}/{id}', function () {
        return view('Employee.InviteEmployee.inviteEmployee');
    });
    Route::get('/invite-employee-list', function () {
        return view('Employee.inviteEmployeeList');
    })->middleware('Permissions:Invite Employee List View');
    Route::resource('/pre-require', PreRequestController::class)->middleware('Permissions:Registration Setting View');
    Route::resource('/emp-permit', EmpPermitController::class);
    Route::resource('/emp-work-experience', EmpWorkExperienceController::class);
    Route::resource('/emp-worker-type', EmpWorkerTypeController::class);
    Route::resource('/required-document', RequiredDocumentController::class);
    Route::post('/required-document/update', [RequiredDocumentController::class, 'update']);
    Route::post('/required-document-field-delete', [RequiredDocumentController::class, 'delete_field']);
    Route::post('/update-get-types/{id}', [RequiredDocumentController::class, 'update_get_types']);
    Route::resource('/required-external-document', RequiredExternalDocumentController::class);
    Route::post('/external-update-get-types/{id}', [RequiredExternalDocumentController::class, 'external_update_get_types']);
    Route::resource('/emp-type', EmpTypeController::class);
    Route::resource('/emp-team', EmpTeamController::class);

    Route::resource('/settings', SettingsController::class)->middleware('Permissions:General Settings View');
    Route::get('attendance-logs', function(){ return view('attendance-logs');});
    Route::get('get-attendance-logs', [SettingsController::class, 'getAttendanceLogs']);

    Route::resource('/role', RoleController::class);
    // Route::resource('/incident-injury-classification', IncidentInjuryClassificationController::class);
    Route::resource('/training', TrainingController::class);

    Route::resource('/incident-notifi-classification', NotifiableClassificationController::class);
    Route::post('/tier-related-data', [RoleController::class, 'tierRelatedData']);
    Route::get('/send-invite', [EmployeeOnboardingController::class, 'sendInvite']);
    Route::put('/add-remove-team-member', [EmpTeamController::class, 'addRemoveTeamMember']);
    Route::post('/get-team-member', [EmpTeamController::class, 'GetTeamMember']);
    Route::post('/get-team-history', [EmpTeamController::class, 'GetTeamHistory']);
    // modification

    Route::resource('sites', SiteController::class)->middleware('Permissions:Sites View');
    Route::get('sites', function () {
        return view('Sites.index');
    })->middleware('Permissions:Sites View');
    Route::get('/site-view/{id}', [SiteController::class, 'view'])->middleware('Permissions:Sites View');



    //  =====================  MEETING ROUTE END =========================

    Route::get('/search/employees', [MeetingController::class, 'searchEmployees']);

    Route::get('/roaster', function () {
        return view('Roaster.view');
    })->middleware('Permissions:Roster View');
    ////////////////////Payroll//////////////////
    Route::resource('payroll', PayRollController::class)->middleware('Permissions:Roster View');
    Route::get('/payroll/{id}/toggle-status', [PayRollController::class, 'toggleStatus'])->name('payroll.toggleStatus');
    Route::get('/payroll/{id}/receipt', [PayRollController::class, 'getPayrollReceipt']);
    Route::post('/payroll/{id}/save-pdf', [PayRollController::class, 'savePayrollPdf'])->name('payroll.save-pdf');
    Route::get('/payroll/{id}/download-pdf', [PayRollController::class, 'downloadPayrollPdf'])->name('payroll.download-pdf');
    Route::get('/api/get-roster-working-hours', [PayrollController::class, 'getRosterWorkingHours']);
    Route::get('/generate/slips', [PayRollController::class, 'selectEmployeesForPayslip'])->name('payroll.select_employees');
    Route::post('/generate/selected-slips', [PayRollController::class, 'generateSelectedSlips'])->name('generate.selectedemp');
    Route::get('/payroll/{id}/details', [PayRollController::class, 'viewDetails'])->name('payroll.details');
    Route::get('/payroll/{id}/attendance-pdf', [PayRollController::class, 'attendancePdf'])->name('payroll.attendance_pdf');
    Route::post('/payroll/{id}/send-receipt-email', [PayRollController::class, 'sendReceiptEmail'])->name('payroll.send_receipt_email');
    Route::post('/payroll/bulk-delete', [PayRollController::class, 'bulkDelete'])->name('payroll.bulk_delete');
    //////////////////Fine/////////////////////
    Route::get('/fine-management', [PayRollController::class, 'fine_management'])->name('fine.management');
    Route::get('/fine/create', [PayRollController::class, 'fine_create'])->name('fine.create');
    Route::post('/fine/store', [PayRollController::class, 'fine_store'])->name('fine.store');
    Route::get('/fine/edit/{id}', [PayRollController::class, 'fine_edit'])->name('fine.edit');
    Route::put('/fine/update/{id}', [PayRollController::class, 'fine_update'])->name('fine.update');
    Route::delete('/fine/destroy/{id}', [PayRollController::class, 'fine_destroy'])->name('fine.destroy');

    //////////////Salary////////////////
    Route::get('/set-salary', [PayRollController::class, 'salary_index'])->name('salary.index');
    Route::get('/salary/create', [PayRollController::class, 'salary_create'])->name('salary.create');
    Route::post('/salary/store', [PayRollController::class, 'salary_store'])->name('salary.store');
    Route::delete('/salary/destroy/{id}', [PayRollController::class, 'salary_destroy'])->name('salary.destroy');
    Route::get('/salary/edit/{id}', [PayRollController::class, 'salary_edit'])->name('salary.edit');
    Route::put('/salary/update/{id}', [PayRollController::class, 'salary_update'])->name('salary.update');

    ///  over time 

    Route::get('overtimes', [OvertimeController::class, 'index'])->name('overtimes.index');
    Route::get('overtimes/create', [OvertimeController::class, 'create'])->name('overtimes.create');
    Route::post('overtimes', [OvertimeController::class, 'store'])->name('overtimes.store');
    Route::get('overtimes/{id}', [OvertimeController::class, 'show'])->name('overtimes.show');
    Route::get('overtimes/{id}/edit', [OvertimeController::class, 'edit'])->name('overtimes.edit');
    Route::put('overtimes/{id}', [OvertimeController::class, 'update'])->name('overtimes.update');
    Route::delete('overtimes/{id}', [OvertimeController::class, 'destroy'])->name('overtimes.destroy');
    Route::post('overtimes-update-status', [OvertimeController::class, 'updateStatus']);
    Route::get('public-holiday', function () {
        return view('Holiday.index');
    })->middleware('Permissions:Public Holiday View');
    Route::get('leave-type', function () {
        return view('LeaveType.index');
    })->middleware('Permissions:Leave Type View');

    Route::resource('leavepackage', LeavePackageController::class)->middleware('Permissions:Leave Package View');
    Route::get('leavepackage', function () {
        return view('LeavePackage.index');
    })->middleware('Permissions:Leave Package View');
    Route::resource('leave-request', LeaveRequestController::class)->middleware('Permissions:Leave Request View');
    Route::get('leave-request', function () {
        return view('LeaveRequest.index');
    })->middleware('Permissions:Leave Request View');
    Route::get('/leave-view/{id}', [LeaveRequestController::class, 'view'])->middleware('Permissions:Leave Request View');
    Route::get('tiers', function () {
        return view('Tier.index');
    })->middleware('Permissions:Tier List View');
    Route::resource('/tier-package', TierPackageController::class)->middleware('Permissions:Tier Package View');
    Route::get('/tier-package', function () {
        return view('TierPackage.index');
    })->middleware('Permissions:Tier Package View');
    Route::get('/leave-portal', [LeaveRequestController::class, 'leave_portal'])->middleware('Permissions:Leaves Portal View');
    // ==============================Attendance=============================
    Route::resource('/attendance', AttendanceController::class)->middleware('Permissions:Attendance View');
    Route::get('attendance_record', function () {
        return view('Attendance.attendanceRecord');
    });
    Route::get('/attendance', function () {
        return view('Attendance.index');
    })->middleware('Permissions:Attendance View');
    Route::delete('/delete-break/{id}', [AttendanceController::class, 'deleteBreak']);
    Route::get('/attendance-request', function () {
        return view('Attendance.attendanceRequest');
    })->middleware('Permissions:Attendance Request View');
    Route::get('/attendance_request', [AttendanceController::class, 'attendance_request']);
    Route::put('attendance{id}/update-status', [AttendanceController::class, 'updateStatus']);
    Route::post('approved-all', [AttendanceController::class, 'approved_all']);
    Route::post('approve-selected', [AttendanceController::class, 'approveSelected']);
    Route::get('/attendance-portal', [AttendanceController::class, 'attendance_portal'])->middleware('Permissions:Attendance Portal View');
    Route::get('/attendance-portal-employee', [AttendanceController::class, 'attendance_portal_employee'])->middleware('Permissions:Attendance Portal View');
    Route::get('/employe-attendance', [AttendanceController::class, 'employe_attendance'])->middleware('Permissions:Attendance Portal View');
    Route::get('attendance-export', [AttendanceController::class, 'attendanceExport'])->middleware('Permissions:Attendance Portal View');
    // =============================Incident ===============================
    Route::get('/incident-report/create/{step}/{incident_report_id}', function () {
        return view('IncidentReport.NewIncidentReport.newIncidentReport');
    });
    Route::get('/incident-report-list', function () {
        return view('IncidentReport.incidentReportList');
    });


    /////////////// GENERATE PDF FOR DOCUMENT SIGNED EMPLOYEES ///////////////////////
    Route::get('/generate-pdf', [MeetingController::class, 'generateSignedDocumentPDF'])->name('generateSignedDocument.pdf');
    Route::get('internal-employee-roster-setting', [SettingsController::class, 'getInternalEmployeeRosterSetting']);
    Route::post('internal-employee-roster-setting', [SettingsController::class, 'internalEmployeeRosterSetting']);
});
Route::view('/first-rest-password', 'Auth/first-rest-password');
Route::get('/leave-update-expired-status', [LeaveRequestController::class, 'update_expired_status']);
Route::get('/two-factor', function () {
    return view('Auth.two-factore');
})->name('Auth.twofactore');
Route::get('/reset-password', function () {
    return view('Auth.reset-password');
})->name('Auth.resetPassword');
Route::get('/forgot-password', function () {
    return view('Auth.forgot-password');
})->name('Auth.forgotPassword');
Route::get('/account-verification', function () {
    return view('Auth.account-verification');
})->name('Auth.accountverification');
Route::get('/update-password-profile', function () {
    return view('Auth.update-password-on-profile');
})->name('Auth.updatepasswordonprofile');
Route::get('/meeting/guest/{id}/{meeting_date}', [MeetingController::class, 'addGuestUser']);
Route::post('guest/add', [MeetingController::class, 'addGuestUserDetailsByGuest']);
Route::get('/guest/success', function () {
    return view('Guest.guest_success');
});
Route::get('/external-employee-onboarding', function () {
    return view('Employee.NewExternalEmployeeOnboarding.registrationForm');
});
Route::get('/edit-external-employee/{id}', function () {
    return view('Employee.NewExternalEmployeeOnboarding.editForm');
});
Route::get('/external-employee-onboarding/success', function () {
    return view('Employee.NewExternalEmployeeOnboarding.success');
});
